/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.commands;

import net.skinsrestorer.api.SkinVariant;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.bukkit.utils.WrapperBukkit;
import net.skinsrestorer.shadow.aikar.commands.BaseCommand;
import net.skinsrestorer.shadow.aikar.commands.CommandHelp;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandAlias;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandCompletion;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandPermission;
import net.skinsrestorer.shadow.aikar.commands.annotation.Default;
import net.skinsrestorer.shadow.aikar.commands.annotation.Description;
import net.skinsrestorer.shadow.aikar.commands.annotation.HelpCommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Optional;
import net.skinsrestorer.shadow.aikar.commands.annotation.Single;
import net.skinsrestorer.shadow.aikar.commands.annotation.Subcommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Syntax;
import net.skinsrestorer.shadow.aikar.commands.bukkit.contexts.OnlinePlayer;
import net.skinsrestorer.shared.commands.ISkinCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="skin")
@CommandPermission(value="%skin")
public class SkinCommand
extends BaseCommand
implements ISkinCommand {
    private final SkinsRestorer plugin;

    @Default
    public void onDefault(CommandSender sender) {
        this.onDefault(WrapperBukkit.wrapCommandSender(sender));
    }

    @Default
    @CommandPermission(value="%skinSet")
    @Description(value="%helpSkinSet")
    @Syntax(value="%SyntaxDefaultCommand")
    public void onSkinSetShort(Player player, @Single String skin) {
        this.onSkinSetShort(WrapperBukkit.wrapPlayer(player), skin);
    }

    @HelpCommand
    @Syntax(value="%helpHelpCommand")
    public void onHelp(CommandSender sender, CommandHelp help) {
        this.onHelp(WrapperBukkit.wrapCommandSender(sender), help);
    }

    @Subcommand(value="clear")
    @CommandPermission(value="%skinClear")
    @Description(value="%helpSkinClear")
    public void onSkinClear(Player player) {
        this.onSkinClear(WrapperBukkit.wrapPlayer(player));
    }

    @Subcommand(value="clear")
    @CommandPermission(value="%skinClearOther")
    @CommandCompletion(value="@players")
    @Syntax(value="%SyntaxSkinClearOther")
    @Description(value="%helpSkinClearOther")
    public void onSkinClearOther(CommandSender sender, @Single OnlinePlayer target) {
        this.onSkinClearOther(WrapperBukkit.wrapCommandSender(sender), WrapperBukkit.wrapPlayer(target.getPlayer()));
    }

    @Subcommand(value="search")
    @CommandPermission(value="%skinSearch")
    @Description(value="%helpSkinSearch")
    @Syntax(value="%SyntaxSkinSearch")
    public void onSkinSearch(CommandSender sender, String search) {
        this.onSkinSearch(WrapperBukkit.wrapCommandSender(sender), search);
    }

    @Subcommand(value="update")
    @CommandPermission(value="%skinUpdate")
    @Description(value="%helpSkinUpdate")
    public void onSkinUpdate(Player player) {
        this.onSkinUpdate(WrapperBukkit.wrapPlayer(player));
    }

    @Subcommand(value="update")
    @CommandPermission(value="%skinUpdateOther")
    @CommandCompletion(value="@players")
    @Description(value="%helpSkinUpdateOther")
    @Syntax(value="%SyntaxSkinUpdateOther")
    public void onSkinUpdateOther(CommandSender sender, @Single OnlinePlayer target) {
        this.onSkinUpdateOther(WrapperBukkit.wrapCommandSender(sender), WrapperBukkit.wrapPlayer(target.getPlayer()));
    }

    @Subcommand(value="set")
    @CommandPermission(value="%skinSet")
    @CommandCompletion(value="@skin")
    @Description(value="%helpSkinSet")
    @Syntax(value="%SyntaxSkinSet")
    public void onSkinSet(Player player, String[] skin) {
        this.onSkinSet(WrapperBukkit.wrapPlayer(player), skin);
    }

    @Subcommand(value="set")
    @CommandPermission(value="%skinSetOther")
    @CommandCompletion(value="@players @skin")
    @Description(value="%helpSkinSetOther")
    @Syntax(value="%SyntaxSkinSetOther")
    public void onSkinSetOther(CommandSender sender, OnlinePlayer target, String skin, @Optional SkinVariant skinVariant) {
        this.onSkinSetOther(WrapperBukkit.wrapCommandSender(sender), WrapperBukkit.wrapPlayer(target.getPlayer()), skin, skinVariant);
    }

    @Subcommand(value="url")
    @CommandPermission(value="%skinSetUrl")
    @CommandCompletion(value="@skinUrl")
    @Description(value="%helpSkinSetUrl")
    @Syntax(value="%SyntaxSkinUrl")
    public void onSkinSetUrl(Player player, String url, @Optional SkinVariant skinVariant) {
        this.onSkinSetUrl(WrapperBukkit.wrapPlayer(player), url, skinVariant);
    }

    public SkinCommand(SkinsRestorer plugin) {
        this.plugin = plugin;
    }

    @Override
    public SkinsRestorer getPlugin() {
        return this.plugin;
    }
}

